local super = require "Artifact"

KeyArtifact = super:new()

function KeyArtifact:new(input)
    self = super.new(self)
    
    self._input = input
    self:trySetValue(self._input, warn)
    self:setUndoable(true)
    
    return self
end

function KeyArtifact:archive()
    local typeName, properties = self:class(), {
        key = self:getInput()
    }
    return typeName, properties
end

function KeyArtifact:trySetValue(input, errorFunction)
    local key = Dataset:normalize(input)
    local dependencies = { key }
    local builtFunction = KeyArtifact.applicatorFunction(key)
    return self:setValue(key, dependencies, builtFunction)
end

function KeyArtifact:unarchiveKey(archived)
    self._input = unarchive(archived)
    self:trySetValue(self._input, warn)
end

KeyArtifact.applicatorFunction = function(key)
    return function(dataset)
        return (dataset and dataset:entrySequence(key)) or Sequence:newWithArray({})
    end
end

return KeyArtifact